% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random-tidy-geom.R
\name{tidy_geometric}
\alias{tidy_geometric}
\title{Tidy Randomly Generated Geometric Distribution Tibble}
\usage{
tidy_geometric(.n = 50, .prob = 1, .num_sims = 1, .return_tibble = TRUE)
}
\arguments{
\item{.n}{The number of randomly generated points you want.}

\item{.prob}{A probability of success in each trial 0 < prob <= 1.}

\item{.num_sims}{The number of randomly generated simulations you want.}

\item{.return_tibble}{A logical value indicating whether to return the result
as a tibble. Default is TRUE.}
}
\value{
A tibble of randomly generated data.
}
\description{
This function will generate \code{n} random points from a geometric
distribution with a user provided, \code{.prob}, and number of
random simulations to be produced. The function returns a tibble with the
simulation number column the x column which corresponds to the n randomly
generated points, the \code{d_}, \code{p_} and \code{q_} data points as well.

The data is returned un-grouped.

The columns that are output are:
\itemize{
\item \code{sim_number} The current simulation number.
\item \code{x} The current value of \code{n} for the current simulation.
\item \code{y} The randomly generated data point.
\item \code{dx} The \code{x} value from the \code{\link[stats:density]{stats::density()}} function.
\item \code{dy} The \code{y} value from the \code{\link[stats:density]{stats::density()}} function.
\item \code{p} The values from the resulting p_ function of the distribution family.
\item \code{q} The values from the resulting q_ function of the distribution family.
}
}
\details{
This function uses the underlying \code{stats::rgeom()}, and its underlying
\code{p}, \code{d}, and \code{q} functions. For more information please see \code{\link[stats:Geometric]{stats::rgeom()}}
}
\examples{
tidy_geometric()

}
\seealso{
\url{https://en.wikipedia.org/wiki/Geometric_distribution}

Other Continuous Distribution: 
\code{\link{tidy_beta}()},
\code{\link{tidy_burr}()},
\code{\link{tidy_cauchy}()},
\code{\link{tidy_chisquare}()},
\code{\link{tidy_exponential}()},
\code{\link{tidy_f}()},
\code{\link{tidy_gamma}()},
\code{\link{tidy_generalized_beta}()},
\code{\link{tidy_generalized_pareto}()},
\code{\link{tidy_inverse_burr}()},
\code{\link{tidy_inverse_exponential}()},
\code{\link{tidy_inverse_gamma}()},
\code{\link{tidy_inverse_normal}()},
\code{\link{tidy_inverse_pareto}()},
\code{\link{tidy_inverse_weibull}()},
\code{\link{tidy_logistic}()},
\code{\link{tidy_lognormal}()},
\code{\link{tidy_normal}()},
\code{\link{tidy_paralogistic}()},
\code{\link{tidy_pareto1}()},
\code{\link{tidy_pareto}()},
\code{\link{tidy_triangular}()},
\code{\link{tidy_t}()},
\code{\link{tidy_uniform}()},
\code{\link{tidy_weibull}()},
\code{\link{tidy_zero_truncated_geometric}()}

Other Geometric: 
\code{\link{tidy_zero_truncated_geometric}()},
\code{\link{util_geometric_param_estimate}()},
\code{\link{util_geometric_stats_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Continuous Distribution}
\concept{Geometric}
