% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-aic-lognormal.R
\name{util_lognormal_aic}
\alias{util_lognormal_aic}
\title{Calculate Akaike Information Criterion (AIC) for Log-Normal Distribution}
\usage{
util_lognormal_aic(.x)
}
\arguments{
\item{.x}{A numeric vector containing the data to be fitted to a log-normal distribution.}
}
\value{
The AIC value calculated based on the fitted log-normal distribution to the provided data.
}
\description{
This function estimates the meanlog and sdlog parameters of a log-normal
distribution from the provided data using maximum likelihood estimation,
and then calculates the AIC value based on the fitted distribution.
}
\details{
This function calculates the Akaike Information Criterion (AIC) for a log-normal distribution fitted to the provided data.

This function fits a log-normal distribution to the provided data using maximum
likelihood estimation. It estimates the meanlog and sdlog parameters
of the log-normal distribution using maximum likelihood estimation. Then, it
calculates the AIC value based on the fitted distribution.

Initial parameter estimates: The function uses the method of moments estimates
as starting points for the meanlog and sdlog parameters of the log-normal
distribution.

Optimization method: The function uses the optim function for optimization.
You might explore different optimization methods within optim for potentially
better performance.

Goodness-of-fit: While AIC is a useful metric for model comparison, it's
recommended to also assess the goodness-of-fit of the chosen model using
visualization and other statistical tests.
}
\examples{
# Example 1: Calculate AIC for a sample dataset
set.seed(123)
x <- rlnorm(100, meanlog = 0, sdlog = 1)
util_lognormal_aic(x)

}
\seealso{
Other Utility: 
\code{\link{check_duplicate_rows}()},
\code{\link{convert_to_ts}()},
\code{\link{quantile_normalize}()},
\code{\link{tidy_mcmc_sampling}()},
\code{\link{util_beta_aic}()},
\code{\link{util_binomial_aic}()},
\code{\link{util_cauchy_aic}()},
\code{\link{util_chisq_aic}()},
\code{\link{util_exponential_aic}()},
\code{\link{util_gamma_aic}()},
\code{\link{util_geometric_aic}()},
\code{\link{util_hypergeometric_aic}()},
\code{\link{util_logistic_aic}()},
\code{\link{util_normal_aic}()},
\code{\link{util_pareto_aic}()},
\code{\link{util_poisson_aic}()},
\code{\link{util_uniform_aic}()},
\code{\link{util_weibull_aic}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
