% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_frailty_sd}
\alias{plot_frailty_sd}
\title{Plot for the Frailty Standard Deviation or Variance}
\usage{
plot_frailty_sd(
  result,
  frailty_sd = NULL,
  flag_variance = FALSE,
  flag_sd_external = FALSE,
  xlim = c(1, length(result$TimeDomain) - 1),
  ylim = c(0, 10),
  xlab = "Intervals",
  ylab = "Values",
  main_title = "Frailty standard deviation",
  pch = 21,
  color_bg = "blue",
  cex_points = 0.7
)
}
\arguments{
\item{result}{An S3 object of class 'AdPaik', returned by the main model call 'AdPaikModel(...)'.}

\item{frailty_sd}{A numerical vector representing the evaluated frailty standard deviation, with length equal to the number of time-domain intervals.
Its elements must be non-negative.}

\item{flag_variance}{A boolean flag indicating whether to plot the frailty variance (\code{TRUE}) or the frailty standard deviation (\code{FALSE}). Default is \code{FALSE}.}

\item{flag_sd_external}{A logical flag indicating whether the user is providing an external frailty standard deviation vector.}

\item{xlim}{A numeric vector of length 2, defining the range for the x-axis (intervals). Default is from 1 to the number of intervals.}

\item{ylim}{A numeric vector of length 2, defining the range for the y-axis (values). Default is \verb{(0, 10)}.}

\item{xlab}{A string for the x-axis label. Default is \code{'Intervals'}.}

\item{ylab}{A string for the y-axis label. Default is \code{'Values'}.}

\item{main_title}{A string for the plot title. Default title is \code{'Frailty Standard Deviation'}.}

\item{pch}{A numeric or character symbol used for plotting the frailty standard deviation values. Default is a dot (\code{21}).}

\item{color_bg}{A string specifying the color used for the symbols. Default is \code{'blue'}.}

\item{cex_points}{A numeric value indicating the size of the plotting symbols. Default is \code{0.7}.}
}
\value{
A plot displaying either the frailty standard deviation or variance across the specified intervals.
}
\description{
This function generates a plot of either the frailty standard deviation or the frailty variance for the intervals in the time-domain.
}
\details{
The plot represents the values of the frailty standard deviation or variance for each time interval.
It connects these points to illustrate the trend of the chosen metric.

This function supports two modes of operation:
\itemize{
\item Plotting the frailty standard deviation or variance retrieved from the main model (contained in the S3 object of class 'AdPaik').
\item Plotting a user-provided vector of frailty standard deviations, which can be computed using the method \code{frailty.sd}. This allows for flexibility in analysis without re-optimizing the log-likelihood function. For instance, users can compare frailty standard deviations computed with different model specifications (e.g., including only time-dependent terms).
}

The output will differentiate between these two cases, ensuring the correct values are plotted regardless of the source.
}
\examples{
# Import data
data(data_dropout)

# Define the variables needed for the model execution
eps_paik <- 1e-10
categories_range_min <- c(-8, -2, eps_paik, eps_paik, eps_paik)
categories_range_max <- c(-eps_paik, 0.4, 1 - eps_paik, 1, 10)
time_axis <- c(1.0, 1.4, 1.8, 2.3, 3.1, 3.8, 4.3, 5.0, 5.5, 5.8, 6.0)
formula <- time_to_event ~ Gender + CFUP + cluster(group)

# Call the main model function
\donttest{
result <- AdPaikModel(formula, data_dropout, time_axis, categories_range_min, categories_range_max)

plot_frailty_sd(result, ylim=c(0, 0.50), xlab = 'Time [intervals]', ylab = 'Standard deviation')
}
}
