% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-add-variables.R
\name{add_variables}
\alias{add_variables}
\title{Add variables for juveniles, sample length, distance to coast, and distance category}
\usage{
add_variables(
  data,
  JuvLim = 12,
  distance_type = "haversine",
  window = 0.5,
  unit = "nm",
  coastline = NULL,
  suppress_warnings = TRUE
)
}
\arguments{
\item{data}{Data frame that must contain latitude (\code{lat_initial}) and longitude (\code{lon_initial}) coordinates,
as well as columns with individual length.}

\item{JuvLim}{Length threshold to consider juveniles.}

\item{distance_type}{Type of distance calculation to the coast.}

\item{window}{Window parameter to smooth the coastline.}

\item{unit}{Distance unit used in the calculation ("nm", "km", etc.).}

\item{coastline}{Data frame with coastline coordinates. Must have columns named \code{Long} and \code{Lat}.
If \code{NULL}, uses internal dataset \code{peru_coastline}.}

\item{suppress_warnings}{Logical. If TRUE, warnings are suppressed.}
}
\value{
Data frame with new variables: \code{juv} (proportion of juveniles), \code{sample} (total individuals),
\code{dc} (distance to coast), and \code{dc_cat} (categorical distance).
}
\description{
Adds new variables to a dataset, including the proportion of juveniles,
the total number of individuals in the sample, the distance to the coast, and the distance category.
}
\examples{
\dontrun{
data_hauls <- process_hauls(data_hauls = calas_bitacora)
data_fishing_trips <- process_fishing_trips(data_fishing_trips = faenas_bitacora)
hauls_length <- process_length(data_length = tallas_bitacora)

data_length_trips <- merge(
  x = data_fishing_trips, 
  y = hauls_length, 
  by = 'fishing_trip_code'
)
data_total <- merge_length_fishing_trips_hauls(
  data_hauls = data_hauls, 
  data_length_fishing_trips = data_length_trips
)

results <- add_variables(data = data_total)
}

}
