% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-spatial.R
\name{land_points}
\alias{land_points}
\title{Points on land}
\usage{
land_points(
  x_point,
  y_point,
  coastline = NULL,
  parallel = FALSE,
  cores = 4,
  distance_type = "haversine",
  window = 0.5,
  unit = "nm"
)
}
\arguments{
\item{x_point}{Numeric vector of longitudes (in decimal degrees).}

\item{y_point}{Numeric vector of latitudes (in decimal degrees).}

\item{coastline}{Data frame with coastline coordinates. Must have columns named \code{Long} and \code{Lat}.
If \code{NULL}, uses internal dataset \code{peru_coastline}.}

\item{parallel}{Logical. If \code{TRUE}, performs the calculation in parallel using multiple cores.}

\item{cores}{Number of cores to use for parallel processing.}

\item{distance_type}{Type of geodesic distance to use in the calculation.}

\item{window}{Geographic window in degrees to reduce the number of coastline points to consider.}

\item{unit}{Unit of measurement for distance: "km" or "nm".}
}
\value{
Text vector of the same length as \code{x_point}, indicating whether each point
is on "land" or "sea". NA values are maintained as NA.
}
\description{
Classifies a set of geographic coordinates (longitude and latitude) as "land" or "sea"
according to their relative position to a coastline. A point is considered to be on land
if its longitude is greater than that of its nearest point on the coastline.
}
\examples{
\dontrun{
data_hauls <- process_hauls(data_hauls = calas_bitacora)
result <- land_points(
  x_point = data_hauls$lon_final,
  y_point = data_hauls$lat_final
)
table(result)
}

}
