% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dokuwiki.R
\name{dokuwiki}
\alias{dokuwiki}
\title{Create tables in dokuwiki format}
\usage{
dokuwiki(x, headersep = "^", sep = "|", clip = TRUE, ...)
}
\arguments{
\item{x}{A data.frame.}

\item{headersep}{The separator used between entries in the header row.}

\item{sep}{The separator used between entries in all other rows.}

\item{clip}{Whether or not to write the returned table to the clipboard (currently only supported on Mac OS X).}

\item{...}{Further arguments passed to \code{write.table}.}
}
\description{
Prints the supplied data frame or matrix using Dokuwiki's table syntax, optionally copying the data to the clipboard (Mac OS X only).
}
\examples{
dokuwiki(head(iris), clip=FALSE)
dokuwiki(head(mtcars), clip=FALSE, row.names=TRUE)

}
\author{
Stephen Turner
}
