% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugDoseResponseCurve.R
\name{drugDoseResponseCurve}
\alias{drugDoseResponseCurve}
\title{Plot drug response curve of a given drug and a given cell for a list of tSets (objects of the ToxicoSet class).}
\usage{
drugDoseResponseCurve(drug, cellline, durations, tSets = list(),
  concentrations = list(), viabilities = list(), conc_as_log = FALSE,
  viability_as_pct = TRUE, trunc = TRUE,
  legends.label = c("ic50_published", "gi50_published", "auc_published",
  "auc_recomputed", "ic50_recomputed"), ylim = c(0, 100), xlim, mycol,
  title, plot.type = c("Fitted", "Actual", "Both"),
  summarize.replicates = TRUE, lwd = 0.5, cex = 0.5,
  cex.main = 0.9, legend.loc = "topright", verbose = TRUE)
}
\arguments{
\item{drug}{[string] A drug name for which the drug response curve should be
plotted. If the plot is desirable for more than one toxico set, A unique drug id
should be provided.}

\item{cellline}{[string] A cell line name for which the drug response curve should be
plotted. If the plot is desirable for more than one toxico set, A unique cell id
should be provided.}

\item{durations}{[numeric] A duration for which the drug response curve should be plotted.}

\item{tSets}{[list] a list of ToxicoSet objects, for which the function
should plot the curves.}

\item{concentrations, viabilities}{[list] A list of concentrations and viabilities to plot, the function assumes that
concentrations[[i]] is plotted against viabilities[[i]]. The names of the concentration list are used to create the legend labels}

\item{conc_as_log}{[logical], if true, assumes that log10-concentration data has been given rather than concentration data,
and that log10(ICn) should be returned instead of ICn. Applies only to the concentrations parameter.}

\item{viability_as_pct}{[logical], if false, assumes that viability is given as a decimal rather
than a percentage, and that E_inf passed in as decimal. Applies only to the viabilities parameter.}

\item{trunc}{[bool] Should the viability values be truncated to lie in [0-100] before doing the fitting}

\item{legends.label}{[vector] A vector of sensitivity measurment types.
A legend will be displayed on the top right of the plot which each line of the legend is
the values of requested sensitivity measurements for one of the requested tSets.
If this parameter is missed no legend would be provided for the plot.}

\item{ylim}{[vector] A vector of two numerical values to be used as ylim of the plot.
If this parameter would be missed c(0,100) would be used as the ylim of the plot.}

\item{xlim}{[vector] A vector of two numerical values to be used as xlim of the plot.
If this parameter would be missed the minimum and maximum comncentrations between all
the tSets would be used as plot xlim.}

\item{mycol}{[vector] A vector with the same length of the tSets parameter which
will determine the color of the curve for the toxico sets. If this parameter is
missed default colors from Rcolorbrewer package will be used as curves color.}

\item{title}{[character] The title of the graph. If no title is provided, then it defaults to
'Drug':'Cell Line'.}

\item{plot.type}{[character] Plot type which can be the actual one ("Actual") or
the one fitted by logl logistic regression ("Fitted") or both of them ("Both").
If this parameter is missed by default actual curve is plotted.}

\item{summarize.replicates}{[character] If this parameter is set to true replicates
are summarized and replicates are plotted individually otherwise}

\item{lwd}{[numeric] The line width to plot with}

\item{cex}{[numeric] The cex parameter passed to plot}

\item{cex.main}{[numeric] The cex.main parameter passed to plot, controls the size of the titles}

\item{legend.loc}{And argument passable to xy.coords for the position to place the legend.}

\item{verbose}{[boolean] Should warning messages about the data passed in be printed?}
}
\value{
Plots to the active graphics device and returns and invisible NULL.
}
\description{
Given a list of ToxicoSets, the function will plot the drug_response curve,
for a given drug/cell pair. The y axis of the plot is the viability percentage
and x axis is the log transformed concentrations. If more than one tSet is
provided, a light gray area would show the common concentration range between tSets.
User can ask for type of sensitivity measurment to be shown in the plot legend.
The user can also provide a list of their own concentrations and viability values,
as in the examples below, and it will be treated as experiments equivalent to values coming
from a tSet. The names of the concentration list determine the legend labels.
}
\examples{
if (interactive()) {
drugDoseResponseCurve(concentrations=list("Experiment 1"=c(.008, .04, .2, 1)),
 viabilities=list(c(100,50,30,1)), plot.type="Both")
}

}
