% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signatureClass.R
\name{showSigAnnot}
\alias{showSigAnnot}
\title{Show the Annotations of a signature object}
\usage{
showSigAnnot(Sigs)
}
\arguments{
\item{Sigs}{An object of the \code{ToxicoSig} Class, as returned by \code{drugPerturbationSig}}
}
\value{
Prints the ToxicoGx Signatures annotations to the output stream, and returns invisible NULL.
}
\description{
This funtion prints out the information about the call used to compute the drug signatures, and the session info
for the session in which the computation was done. Useful for determining the exact conditions used to generate signatures.
}
\examples{
data(TGGATESsmall)
drug.perturbation <- drugPerturbationSig(TGGATESsmall, mDataType="rna", nthread=1, duration = "2",
     drugs = head(drugNames(TGGATESsmall)), features = fNames(TGGATESsmall, "rna")[seq_len(2)])
showSigAnnot(drug.perturbation)

}
