% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugGeneResponseCurve.R
\name{drugGeneResponseCurve}
\alias{drugGeneResponseCurve}
\title{Compares gene expression for a specificed set of features over specific
  drug dosages vs time}
\usage{
drugGeneResponseCurve(
  tSet,
  duration = NULL,
  cell_lines = NULL,
  mDataTypes = NULL,
  features = NULL,
  dose = NULL,
  drug = NULL,
  summarize_replicates = TRUE,
  line_width = 1,
  point_size = 2.5,
  ggplot_args = NULL,
  verbose = TRUE
)
}
\arguments{
\item{tSet}{\code{ToxicoSet} A ToxicoSet to be plotted in this graph. Currently
only a single tSet is supported.}

\item{duration}{\code{character} A vector of durations to include in the plot.}

\item{cell_lines}{\code{character} A vector of cell lines to include in the plot.}

\item{mDataTypes}{\code{vector} A vector specifying the molecular data types to
include in this plot. Defaults to the first mDataType if not specified.ex
This release version only accepts one mDataType, more to be added in
forthcoming releases.}

\item{features}{\code{character} A vector of feature names to include in the plot.
If you specify more than two dose levels, you may only pass in up to two features.}

\item{dose}{\code{character} A vector of dose levels to be included in the
plot. Default to include all dose levels available for a drug. If you specify
more than two features you may only pass in up to two dose levels.}

\item{drug}{\code{character} A drug name to include in this plot.
See drugNames(tSet) for a list of options.}

\item{summarize_replicates}{\code{logical} If TRUE will average viability
across replicates for each unique drug-dose-duration combination.}

\item{line_width}{\code{numeric} A number specifying the thickness of lines
in the plot, as passed to size in geom_line(). Defaults to 1.}

\item{point_size}{\code{numeric} A number specifying how large points should
be in the plot, as passed to size in geom_point(). Defaults to 2.5.}

\item{ggplot_args}{\code{list} A list of ggplot2 functions which can be called using the plot + function()
syntax. This allows arbitrary customization of the plot including changing the title, axis labels, colours, etc.
Please see the included examples for basic usage or ggplot2 documentation for advanced customization.}

\item{verbose}{\code{boolean} Should warning messages about the data passed
in be printed?}
}
\value{
Plot of the viabilities for each drug vs time of exposure
}
\description{
This function generates a plot visualizing the relationship between gene
  expression, time and dose level for the selected tSet. The plot is generated
  with ggplot2 and can be customized using ggplot plot + function() syntax.
}
\examples{

if (interactive()) {
  drugGeneResponseCurve(TGGATESsmall, dose = c("Control", "Low", "Middle"),
  mDataTypes="rna", drug = drugNames(TGGATESsmall)[1],
  duration = c("2", "8", "24"), features = "ENSG00000000003_at")
}

}
