% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift_bindings.R
\name{set_denoms_by}
\alias{set_denoms_by}
\title{Set variables used in pct denominator calculation}
\usage{
set_denoms_by(x, ...)
}
\arguments{
\item{x}{A count/shift layer object}

\item{...}{Unquoted variable names}
}
\value{
The modified layer object
}
\description{
This function is used when calculating pct in count or shift layers. The
percentages default to the treatment variable and any column variables but
can be calculated on any variables passed to target_var, treat_var, by, or
cols.
}
\examples{
library(magrittr)

# Default has matrix of treatment group, additional columns,
# and by variables sum to 1
tplyr_table(mtcars, am) \%>\%
  add_layer(
    group_shift(vars(row=gear, column=carb), by=cyl) \%>\%
      set_format_strings(f_str("xxx (xx.xx\%)", n, pct))
  ) \%>\%
  build()

tplyr_table(mtcars, am) \%>\%
  add_layer(
    group_shift(vars(row=gear, column=carb), by=cyl) \%>\%
      set_format_strings(f_str("xxx (xx.xx\%)", n, pct)) \%>\%
      set_denoms_by(cyl, gear) # Row \% sums to 1
  ) \%>\%
  build()

tplyr_table(mtcars, am) \%>\%
  add_layer(
    group_shift(vars(row=gear, column=carb), by=cyl) \%>\%
      set_format_strings(f_str("xxx (xx.xx\%)", n, pct)) \%>\%
      set_denoms_by(cyl, gear, am) # \% within treatment group sums to 1
  ) \%>\%
  build()
}
