% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_bindings.R
\name{get_by}
\alias{get_by}
\alias{set_by}
\title{Set or return by layer binding}
\usage{
get_by(layer)

set_by(layer, by)
}
\arguments{
\item{layer}{A \code{tplyr_layer} object}

\item{by}{A string, a variable name, or a list of variable names supplied
using \code{dplyr::vars}.}
}
\value{
For \code{get_by}, the \code{by} binding of the supplied layer. For
  \code{set_by} the modified layer environment.
}
\description{
Set or return by layer binding
}
\examples{
# Load in pipe
library(magrittr)
iris$Species2 <- iris$Species
lay <- tplyr_table(iris, Species) \%>\%
  group_count(Species) \%>\%
  set_by(vars(Species2, Sepal.Width))
}
