% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormXASampEn.R
\name{NormXASampEn}
\alias{NormXASampEn}
\title{Normalized Cross Sample Entropy}
\usage{
NormXASampEn(x, y, m = 2, r = 0.2)
}
\arguments{
\item{x}{a vector containing the track record of the underlying asset/strategy, this will be normalized during the algorithm}

\item{y}{a vector containing the track record of the underlying asset/strategy, this will be normalized during the algorithm}

\item{m}{an integer value defining the embedding dimension , default value is 2}

\item{r}{a  double  value defining the tolerance, default value is 0.2}
}
\value{
A value containing the NormXASampEn
}
\description{
Calculates the Normalized Cross Sample Entropy of the track records of two assets/strategies based on the sample entropy.
}
\examples{

x = PerformanceAnalytics::edhec[,c("Short Selling")]
y = PerformanceAnalytics::edhec[,c("Convertible Arbitrage")]
Normalized_Cross_Sample_Entropy = NormXASampEn(x, y, m=2, r=0.2)

}
\references{
Lopez de Prado, Marcos, Codependence (Presentation Slides) (January 2, 2020). Available at SSRN: https://ssrn.com/abstract=3512994
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
