% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer_multittree_share_param.R
\name{infer_multittree_share_param}
\alias{infer_multittree_share_param}
\title{Simultaneously infer transmission trees given phylogenetic trees 
User can specify any subset of parameters that will be shared by providing a character vector of parameter names to 
the argument "share".}
\usage{
infer_multittree_share_param(ptree_lst, w.shape = 2, w.scale = 1,
  ws.shape = w.shape, ws.scale = w.scale, mcmcIterations = 1000,
  thinning = 1, startNeg = 100/365, startOff.r = 1,
  startOff.p = 0.5, startPi = 0.5, prior_pi_a = 1, prior_pi_b = 1,
  updateNeg = TRUE, updateOff.r = TRUE, updateOff.p = FALSE,
  updatePi = TRUE, share = NULL, startCTree_lst = rep(NA,
  length(ptree_lst)), updateTTree = TRUE, optiStart = 2, dateT = Inf,
  verbose = F)
}
\arguments{
\item{ptree_lst}{List of phylogenetic tree}

\item{w.shape}{Shape parameter of the Gamma probability density function representing the generation time}

\item{w.scale}{Scale parameter of the Gamma probability density function representing the generation time}

\item{ws.shape}{Shape parameter of the Gamma probability density function representing the sampling time}

\item{ws.scale}{Scale parameter of the Gamma probability density function representing the sampling time}

\item{mcmcIterations}{Number of MCMC iterations to run the algorithm for}

\item{thinning}{MCMC thinning interval between two sampled iterations}

\item{startNeg}{Starting value of within-host coalescent parameter Ne*g}

\item{startOff.r}{Starting value of parameter off.r}

\item{startOff.p}{Starting value of parameter off.p}

\item{startPi}{Starting value of sampling proportion pi}

\item{prior_pi_a}{First shape parameter of Beta prior for pi}

\item{prior_pi_b}{Second shape parameter of Beta prior for pi}

\item{updateNeg}{Whether of not to update the parameter Ne*g}

\item{updateOff.r}{Whether or not to update the parameter off.r}

\item{updateOff.p}{Whether or not to update the parameter off.p}

\item{updatePi}{Whether or not to update the parameter pi}

\item{share}{Character vector of parameters to be shared. For example, share = c("off.r", "off.p") would 
share the offspring distribution. Allowed parameter names are "neg", "off.r", "off.p" and "pi".}

\item{startCTree_lst}{Optional combined list of trees to start from}

\item{updateTTree}{Whether or not to update the transmission tree}

\item{optiStart}{Type of optimisation to apply to MCMC start point (0=none, 1=slow, 2=fast)}

\item{dateT}{Date when process stops (this can be Inf for fully simulated outbreaks)}

\item{verbose}{Whether or not to use verbose mode (default is false)}
}
\value{
list the same size as input, each element contains posterior transmission trees inferred from
corresponding phylogenetic tree
}
\description{
Simultaneously infer transmission trees given phylogenetic trees 
User can specify any subset of parameters that will be shared by providing a character vector of parameter names to 
the argument "share".
}
\author{
Yuanwei Xu
}
