% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnrichCirclize.R
\name{adjust_export_pathway}
\alias{adjust_export_pathway}
\title{Adjust and Export Pathway Analysis Results}
\usage{
adjust_export_pathway(fgseaRes, nTop = 10)
}
\arguments{
\item{fgseaRes}{Dataframe containing fgsea results with columns 'pathway', 'ES', and 'pval'.}

\item{nTop}{Integer, number of top pathways to select based on the p-value.}
}
\value{
A vector containing combined top upregulated and downregulated pathways.
}
\description{
This function processes a dataframe containing fgsea results. It adjusts pathway names
by removing underscores, converting to lowercase, then capitalizing the first letter,
and joining the components with spaces. It selects and merges the top upregulated
and downregulated pathways based on enrichment score (ES) and p-value.
}
\examples{
# Create a synthetic fgseaRes dataframe
fgseaRes <- data.frame(
 pathway = c("KEGG_APOPTOSIS",
             "GO_CELL_CYCLE",
             "REACTOME_DNA_REPAIR",
             "KEGG_METABOLISM",
             "GO_TRANSPORT"),
 ES = c(0.45, -0.22, 0.56, -0.35, 0.33),
 pval = c(0.001, 0.02, 0.0003, 0.05, 0.01)
)

# Run the function to get top pathways
result <- adjust_export_pathway(fgseaRes = fgseaRes, nTop = 2)

}
