% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NewGgraph.R
\name{new_ggraph}
\alias{new_ggraph}
\title{Generate a graphical representation of pathway gene maps}
\usage{
new_ggraph(
  BP_dataframe,
  BP_ids,
  KEGG_dataframe,
  KEGG_ids,
  MF_dataframe,
  MF_ids,
  REACTOME_dataframe,
  REACTOME_ids,
  CC_dataframe,
  CC_ids,
  DO_dataframe,
  DO_ids
)
}
\arguments{
\item{BP_dataframe}{Dataframe for Biological Process.}

\item{BP_ids}{IDs for Biological Process.}

\item{KEGG_dataframe}{Dataframe for KEGG pathways.}

\item{KEGG_ids}{IDs for KEGG pathways.}

\item{MF_dataframe}{Dataframe for Molecular Function.}

\item{MF_ids}{IDs for Molecular Function.}

\item{REACTOME_dataframe}{Dataframe for REACTOME pathways.}

\item{REACTOME_ids}{IDs for REACTOME pathways.}

\item{CC_dataframe}{Dataframe for Cellular Component.}

\item{CC_ids}{IDs for Cellular Component.}

\item{DO_dataframe}{Dataframe for Disease Ontology.}

\item{DO_ids}{IDs for Disease Ontology.}
}
\value{
A 'ggraph' object representing the pathway gene map visualization.
}
\description{
This function merges multiple gene-pathway related dataframes, processes them
for graph creation, and visualizes the relationships in a dendrogram layout using
the provided node and edge gathering functions from the 'ggraph' package.
}
