% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{writeTLS}
\alias{writeTLS}
\title{Export \emph{TreeLS} point clouds to las/laz files}
\usage{
writeTLS(las, file, col_names = NULL, index = FALSE)
}
\arguments{
\item{las}{\code{\link[lidR:LAS]{LAS}} object.}

\item{file}{file path.}

\item{col_names}{column names from \emph{las} that you wish to export. If left empty, all columns not listed among
\code{\link[lidR:LAS]{the standard LAS attributes}} are added to the file.}

\item{index}{\code{logical} - write lax file also.}
}
\description{
Wrapper to \code{\link[lidR:writeLAS]{writeLAS}}. This function automatically adds new data columns as extra bytes
to the written las/laz file using \code{\link[lidR:add_lasattribute]{add_lasattribute}} internally.
}
\examples{
file = system.file("extdata", "pine.laz", package="TreeLS")
tls = readTLS(file) \%>\% fastPointMetrics#'
tls_file = tempfile(fileext = '.laz')
writeTLS(tls, tls_file)

up_tls = readTLS(tls_file)
summary(up_tls)
}
