% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo.R
\name{Subtree}
\alias{Subtree}
\title{Extract subtree}
\usage{
Subtree(tree, node)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}, with internal numbering
in cladewise order (use \code{\link{Preorder}(tree)} or (slower)
\code{\link{Cladewise}(tree)})}

\item{node}{The number of the node at the base of the clade to be extracted.}
}
\value{
This function returns a tree of class \code{phylo} that represents a clade 
        extracted from the original tree.
}
\description{
Safely extracts a clade from a phylogenetic tree.
}
\details{
Modified from the \pkg{ape} function \code{\link{extract.clade}}, which sometimes behaves erratically.  
Unlike extract.clade, this function supports the extraction of 'clades' that constitute a single tip.
}
\examples{
{
tree <- Preorder(ape::rtree(20, br=NULL))
plot(tree); ape::nodelabels(); ape::nodelabels(33, 33, bg='yellow'); dev.new()
plot(Subtree(tree, 33))
}

}
\author{
Martin R. Smith
}
