% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_info_extra_step.r
\name{ICSteps}
\alias{ICSteps}
\title{Information Content Steps}
\usage{
ICSteps(
  char,
  ambiguousToken = 0,
  expectedMinima = 25L,
  maxIter = 10000L,
  warn = TRUE
)
}
\arguments{
\item{char}{The character in question.}

\item{ambiguousToken}{Which token, if any, corresponds to the ambiguous token
(?) (not yet fully implemented).}

\item{expectedMinima}{sample enough trees that the rarest step counts is expected to be seen
at least this many times.}

\item{maxIter}{Maximum iterations to conduct.}

\item{warn}{Boolean (\code{TRUE}/\code{FALSE}): display warnings when concavity
functions are generated by approximation.}
}
\description{
This function estimates the information content of a character \code{char} when e extra steps
are present, for all possible values of e.
}
\details{
Calculates the number of trees consistent with the character having \emph{e} extra steps, where
\emph{e} ranges from its minimum possible value (i.e. number of different tokens minus one) to its
maximum.  The number of trees with no extra steps can be calculated exactly; the number of trees
with more additional steps must be approximated.
The function samples \code{n.iter} trees, or enough trees that the trees with the minimum number
of steps will be recovered at least \code{expected.minima} times, in order to obtain precise
results.
}
\examples{
# A character that is present in ten taxa and absent in five
character <- c(rep(1, 10), rep(2, 5))
suppressWarnings(ICSteps(character))
}
\references{
\insertRef{Faith2001}{TreeSearch}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\keyword{tree}
