% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_manipulation.R
\name{PrepareDataProfile}
\alias{PrepareDataProfile}
\alias{PrepareDataIW}
\title{Prepare data for Profile Parsimony}
\usage{
PrepareDataProfile(dataset, precision = 1e+06, warn = TRUE)

PrepareDataIW(dataset)
}
\arguments{
\item{dataset}{dataset of class \code{phyDat}}

\item{precision}{number of random trees to generate when calculating Profile curves.
With 22 tokens (taxa):
- Increasing precision from 4e+05 to 4e+06 reduces error by a mean of
0.005 bits for each step after the first (max = 0.11 bits, sd=0.017 bits)
- Increasing precision from 1e+06 to 4e+06 reduces error by a mean of
0.0003 bits for each step after the first (max = 0.046 bits, sd=0.01 bits)}

\item{warn}{Boolean (\code{TRUE}/\code{FALSE}): display warnings when concavity
functions are generated by approximation.}
}
\value{
An object of class \code{phyDat}, with additional attributes.
\code{PrepareDataProfile} adds the attributes:
\itemize{
\item \code{info.amounts}: details the information represented by each
character when subject to N additional steps.
\item \code{split.sizes}: The size of the splits implied by each character
\item \code{bootstrap}: The character vector
\code{c('info.amounts', 'split.sizes')}, indicating attributes to sample
when bootstrapping the dataset (e.g. in Ratchet searches).
}

\code{PrepareDataIW} adds the attribute:
\itemize{
\item \code{min.length}: The minimum number of steps that must be present in each
transformation series.
}
}
\description{
Prepare data for Profile Parsimony
}
\section{Functions}{
\itemize{
\item \code{PrepareDataIW}: Prepare data for implied weighting
}}

\author{
Martin R. Smith; written with reference to
\code{phangorn:::prepareDataFitch()}
}
