% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bootstrap.R
\name{MorphyBootstrap}
\alias{MorphyBootstrap}
\alias{ProfileBootstrap}
\alias{IWBootstrap}
\title{Ratchet bootstrapper}
\usage{
MorphyBootstrap(
  edgeList,
  morphyObj,
  EdgeSwapper = NNISwap,
  maxIter,
  maxHits,
  verbosity = 1L,
  stopAtPeak = FALSE,
  stopAtPlateau = 0L,
  ...
)

ProfileBootstrap(
  edgeList,
  dataset,
  EdgeSwapper = NNISwap,
  maxIter,
  maxHits,
  verbosity = 1L,
  ...
)

IWBootstrap(
  edgeList,
  dataset,
  concavity = 10L,
  EdgeSwapper = NNISwap,
  maxIter,
  maxHits,
  verbosity = 1L,
  ...
)
}
\arguments{
\item{edgeList}{a list containing the following:
- vector of integers corresponding to the parent of each edge in turn
- vector of integers corresponding to the child of each edge in turn
- (optionally) score of the tree
- (optionally, if score provided) number of times this score has been hit}

\item{morphyObj}{Object of class \code{morphy}, perhaps created with
\code{\link[=PhyDat2Morphy]{PhyDat2Morphy()}}.}

\item{EdgeSwapper}{a function that rearranges a parent and child vector,
and returns a list with modified vectors; for example \code{\link[=SPRSwap]{SPRSwap()}}.}

\item{maxIter}{maximum number of iterations to perform in tree search}

\item{maxHits}{maximum number of hits to accomplish in tree search}

\item{verbosity}{Level of detail to display in console: larger numbers provide
more verbose feedback to the user.}

\item{stopAtPeak}{Logical specifying whether to terminate search once a subsequent
iteration recovers a sub-optimal score. Useful with methods that
return all trees one rearrangement from the current tree, such
as \code{\link[=AllTBR]{AllTBR()}}.  Will be overridden if a passed function
has an attribute \code{stopAtPeak} set by
\code{attr(FunctionName, 'stopAtPeak') <- TRUE}.}

\item{stopAtPlateau}{Integer. If > 0, tree search will terminate if the score
has not improved after \code{stopAtPlateau} iterations.
Useful with methods that return all trees one rearrangement from the current
tree, such as \code{\link[=AllTBR]{AllTBR()}}.
Will be overridden if a passed function has an attribute \code{stopAtPlateau} set
by \code{attr(FunctionName, 'stopAtPlateau') <- TRUE}.}

\item{\dots}{further parameters to send to \code{TreeScorer()}}

\item{dataset}{A phylogenetic data matrix of class \code{\link[phangorn]{phyDat}},
whose names correspond to the labels of any accompanying tree.}

\item{concavity}{A numeric value to use as the concavity constant (\code{k})
in implied weighting. Defaults to 10; TNT sets a default of 3, but this
is too low in some circumstances (Smith, 2019).}
}
\value{
A tree that is optimal under a random sampling of the original characters
}
\description{
Ratchet bootstrapper
}
\section{Functions}{
\itemize{
\item \code{ProfileBootstrap}: Bootstrapper for Profile Parsimony

\item \code{IWBootstrap}: Bootstrapper for Implied weighting
}}

\references{
\itemize{
\item \insertRef{SmithTern}{TreeSearch}
}
}
