% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KeptPaths.R
\name{KeptPaths}
\alias{KeptPaths}
\alias{KeptPaths.data.frame}
\alias{KeptPaths.matrix}
\title{Paths present in reduced tree}
\usage{
KeptPaths(paths, keptVerts, all = TRUE)

\method{KeptPaths}{data.frame}(paths, keptVerts, all = TRUE)

\method{KeptPaths}{matrix}(paths, keptVerts, all = TRUE)
}
\arguments{
\item{paths}{\code{data.frame} of paths in master tree, perhaps generated using
\code{\link[=PathLengths]{PathLengths()}}.}

\item{keptVerts}{Logical specifying whether each entry is retained in the
reduced tree, perhaps generated using \code{\link[=KeptVerts]{KeptVerts()}}.}

\item{all}{Logical: if \code{TRUE}, return all paths that occur in the reduced
tree; if \code{FALSE}, return only those paths that correspond to a single edge.
that correspond to edges in the reduced tree.
Ignored if \code{paths} is a matrix.}
}
\value{
\code{KeptPaths()} returns a logical vector specifying whether each path
in \code{paths} occurs when \code{keptVerts} vertices are retained.
}
\description{
Lists which paths present in a master tree are present when leaves are
dropped.
}
\examples{
master <- BalancedTree(9)
paths <- PathLengths(master)
keptTips <- c(1, 5, 7, 9)
keptVerts <- KeptVerts(master, keptTips)
KeptPaths(paths, keptVerts)
paths[KeptPaths(paths, keptVerts, all = FALSE), ]
}
\seealso{
Other tree manipulation: 
\code{\link{AddTip}()},
\code{\link{CollapseNode}()},
\code{\link{ConsensusWithout}()},
\code{\link{DropTip}()},
\code{\link{EnforceOutgroup}()},
\code{\link{ImposeConstraint}()},
\code{\link{KeptVerts}()},
\code{\link{LeafLabelInterchange}()},
\code{\link{MakeTreeBinary}()},
\code{\link{RenumberTips}()},
\code{\link{RenumberTree}()},
\code{\link{Renumber}()},
\code{\link{RootTree}()},
\code{\link{SortTree}()},
\code{\link{Subtree}()},
\code{\link{TipTimedTree}()},
\code{\link{TrivialTree}}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree manipulation}
