% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Splits.R
\name{Splits}
\alias{Splits}
\alias{as.Splits}
\alias{as.Splits.phylo}
\alias{as.Splits.multiPhylo}
\alias{as.Splits.Splits}
\alias{as.Splits.list}
\alias{as.Splits.matrix}
\alias{as.Splits.logical}
\alias{as.logical.Splits}
\title{Convert object to \code{Splits}}
\usage{
as.Splits(x, tipLabels = NULL, ...)

\method{as.Splits}{phylo}(x, tipLabels = NULL, asSplits = TRUE, ...)

\method{as.Splits}{multiPhylo}(x, tipLabels = x[[1]]$tip.label, asSplits = TRUE, ...)

\method{as.Splits}{Splits}(x, tipLabels = NULL, ...)

\method{as.Splits}{list}(x, tipLabels = NULL, asSplits = TRUE, ...)

\method{as.Splits}{matrix}(x, tipLabels = NULL, ...)

\method{as.Splits}{logical}(x, tipLabels = NULL, ...)

\method{as.logical}{Splits}(x, tipLabels = NULL, ...)
}
\arguments{
\item{x}{Object to convert into splits: perhaps a tree of class
\code{\link[ape:read.tree]{phylo}}.
If a logical matrix is provided, each row will be considered as a
separate split.}

\item{tipLabels}{Character vector specifying sequence in which to order
tip labels.  Label order must (currently) match to combine or compare separate
\code{Splits} objects.}

\item{\dots}{Presently unused.}

\item{asSplits}{Logical specifying whether to return a \code{Splits} object,
or an unannotated two-dimensional array (useful where performance is
paramount).}
}
\value{
\code{as.Splits()} returns an object of class \code{Splits}, or
(if \code{asSplits = FALSE}) a two-dimensional array of \code{raw} objects, with
each bit specifying whether or not the leaf corresponding to the respective
bit position is a member of the split.
Splits are named according to the node at the non-root end of the edge that
defines them. In rooted trees, the child of the rightmost root edge names
the split.
}
\description{
\code{as.Splits()} converts a phylogenetic tree to a \code{Splits} object representing
its constituent bipartition splits.
}
\examples{
splits <- as.Splits(BalancedTree(letters[1:6]))
summary(splits)
TipsInSplits(splits)
summary(!splits)
TipsInSplits(!splits)

length(splits + !splits)
length(unique(splits + !splits))

summary(c(splits[[2:3]], !splits[[1:2]]))

moreSplits <- as.Splits(PectinateTree(letters[6:1]), tipLabel = splits)
print(moreSplits, details = TRUE)
match(splits, moreSplits)
moreSplits \%in\% splits

}
\seealso{
Other Splits operations: 
\code{\link{LabelSplits}()},
\code{\link{NSplits}()},
\code{\link{NTip}()},
\code{\link{PolarizeSplits}()},
\code{\link{SplitFrequency}()},
\code{\link{SplitsInBinaryTree}()},
\code{\link{TipLabels}()},
\code{\link{TipsInSplits}()},
\code{\link{match}()}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{Splits operations}
