% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTRFunctions.R
\name{diurnal_temp_variation_sineexp}
\alias{diurnal_temp_variation_sineexp}
\title{Hourly Temperature Variation assuming Sine and Exponential Components}
\usage{
diurnal_temp_variation_sineexp(
  T_max,
  T_min,
  t,
  t_r,
  t_s,
  alpha = 2.59,
  beta = 1.55,
  gamma = 2.2
)
}
\arguments{
\item{T_max, T_min}{\code{numeric} maximum and minimum daily temperatures (C).}

\item{t}{\code{numeric} time for temperature estimate (hour).}

\item{t_r, t_s}{\code{numeric} times of sunrise and sunset (hour).}

\item{alpha}{\code{numeric} time difference between \code{t_x} (time of maximum temperature) and noon (hour).}

\item{beta}{\code{numeric} time difference between \code{t_x} and sunrise (hour).}

\item{gamma}{\code{numeric} decay parameter for rate of \code{t} change from sunset to \code{t_n} (time of minimum temp).}
}
\value{
\code{numeric} temperature (C) at a specified hour.
}
\description{
The function estimates temperature across hours using a diurnal temperature variation function incorporating sine and exponential components \insertCite{Parton1981}{TrenchR}.
}
\details{
Default \code{alpha}, \code{beta}, and \code{gamma} values are the average of 5 North Carolina sites \insertCite{Wann1985}{TrenchR}. 
 \cr \cr
 Other \code{alpha}, \code{beta}, and \code{gamma} parameterizations include values for Denver, Colorado from \insertCite{Parton1981;textual}{TrenchR}: \itemize{
  \item{150 cm air temperature}{: \code{alpha} = 1.86, \code{beta} = 2.20, \code{gamma} = -0.17}
  \item{10 cm air temperature}{: \code{alpha} = 1.52, \code{beta} = 2.00, \code{gamma} = -0.18}
  \item{soil surface temperature}{: \code{alpha} = 0.50, \code{beta} = 1.81, \code{gamma} = 0.49}
  \item{10cm soil temperature}{: \code{alpha} = 0.45, \code{beta} = 2.28, \code{gamma} = 1.83}
 }
}
\examples{
  diurnal_temp_variation_sineexp(T_max = 30, 
                                 T_min = 10, 
                                 t     = 11, 
                                 t_r   = 6, 
                                 t_s   = 18, 
                                 alpha = 2.59, 
                                 beta  = 1.55, 
                                 gamma = 2.2)

}
\references{
\insertAllCited{}
}
\seealso{
Other microclimate functions: 
\code{\link{air_temp_profile_neutral}()},
\code{\link{air_temp_profile_segment}()},
\code{\link{air_temp_profile}()},
\code{\link{degree_days}()},
\code{\link{direct_solar_radiation}()},
\code{\link{diurnal_radiation_variation}()},
\code{\link{diurnal_temp_variation_sinesqrt}()},
\code{\link{diurnal_temp_variation_sine}()},
\code{\link{monthly_solar_radiation}()},
\code{\link{partition_solar_radiation}()},
\code{\link{proportion_diffuse_solar_radiation}()},
\code{\link{solar_radiation}()},
\code{\link{surface_roughness}()},
\code{\link{wind_speed_profile_neutral}()},
\code{\link{wind_speed_profile_segment}()}
}
\concept{microclimate functions}
