% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trial_sequence.R
\name{set_data}
\alias{set_data}
\alias{set_data,trial_sequence_ITT,data.frame-method}
\alias{set_data,trial_sequence_AT,data.frame-method}
\alias{set_data,trial_sequence_PP,data.frame-method}
\title{Set the trial data}
\usage{
set_data(object, data, ...)

\S4method{set_data}{trial_sequence_ITT,data.frame}(
  object,
  data,
  id = "id",
  period = "period",
  treatment = "treatment",
  outcome = "outcome",
  eligible = "eligible"
)

\S4method{set_data}{trial_sequence_AT,data.frame}(
  object,
  data,
  id = "id",
  period = "period",
  treatment = "treatment",
  outcome = "outcome",
  eligible = "eligible"
)

\S4method{set_data}{trial_sequence_PP,data.frame}(
  object,
  data,
  id = "id",
  period = "period",
  treatment = "treatment",
  outcome = "outcome",
  eligible = "eligible"
)
}
\arguments{
\item{object}{A \linkS4class{trial_sequence} object}

\item{data}{A \code{data.frame} containing all the required variables in the person-time format, i.e., the
<U+2018>long<U+2019> format.}

\item{...}{Other arguments used by methods internally.}

\item{id}{Name of the variable for identifiers of the individuals. Default is <U+2018>id<U+2019>.}

\item{period}{Name of the variable for the visit/period. Default is <U+2018>period<U+2019>.}

\item{treatment}{Name of the variable for the treatment indicator at that visit/period. Default is
<U+2018>treatment<U+2019>.}

\item{outcome}{Name of the variable for the indicator of the outcome event at that visit/period. Default is
<U+2018>outcome<U+2019>.}

\item{eligible}{Name of the variable for the indicator of eligibility for the target trial at that visit/period.
Default is <U+2018>eligible<U+2019>.}
}
\value{
An updated \link[=trial_sequence-class]{trial_sequence} object with data
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
data(trial_example)
trial_sequence("ITT") |>
  set_data(
    data = trial_example,
    id = "id",
    period = "period",
    eligible = "eligible",
    treatment = "treatment"
  )

}
