% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtypes_Millar.R
\name{rtypes_Millar}
\alias{rtypes_Millar}
\title{Millar's selectivity types}
\source{
https://www.stat.auckland.ac.nz/~millar/selectware/
}
\usage{
rtypes_Millar(rtype)
}
\arguments{
\item{rtype}{a character string indicating which method for the estimation of selection
curves should be used:
\code{"norm.loc"} for normal with common spread method,
\code{"norm.sca"} for normal with variable spread method,
\code{"lognorm"} for lognormal method,
\code{"binorm.sca"} for bi-normal method,
\code{"bilognorm"} for bi-lognormal method,
\code{"tt.logistic"} for control and logistic method,
\code{"gamma"} for gamma method.}
}
\description{
This function returns a function corresponding to the type of curve
   which was selected to represent the selectivity of nets or hooks.
}
\details{
Function adapted from the selectivity functions provided by
  Prof. Dr. Russell Millar (https://www.stat.auckland.ac.nz/~millar/).
  Until now following curves are incorporated:
  \code{"norm.loc"} for a normal curve with common spread,
   \code{"norm.sca"} for a normal curve with variable spread,
   \code{"lognorm"} for a lognormal curve,
   \code{"binorm.sca"} for a bi-normal curve,
   \code{"bilognorm"} for a bi-lognormal curve,
   \code{"tt.logistic"} for a control and logistic curve.
}
\references{
Millar, R. B., Holst, R., 1997. Estimation of gillnet and hook selectivity
 using log-linear models. \emph{ICES Journal of Marine Science: Journal du Conseil},
 54(3), 471-477.
}

