% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{DesHydro}
\alias{DesHydro}
\title{Design hydrograph extraction}
\usage{
DesHydro(
  x,
  qu = 0.8,
  n = 10,
  thr = 0.975,
  xst = NULL,
  xend = NULL,
  RetAll = FALSE
)
}
\arguments{
\item{x}{a numeric vector. The flow series of interest}

\item{qu}{the quantile of flow which separates peaks and truncates either side of the peak to form the event hydrograph. The default is 0.8}

\item{n}{number of event hydrographs from which to derive the mean hydrograph. Default is 10. Depending on the length of x, there may be less than 10}

\item{thr}{threshold above which event peaks are selected. The default is 0.975}

\item{xst}{an integer to truncate the x axis of the plot and resulting design hydrograph. The first point of the design hydrograph}

\item{xend}{an integer to truncate the x axis of the plot and resulting design hydrograph. The last point of the design hydrograph}

\item{RetAll}{logical argument with a default of false. If TRUE, all the hydrographs from which the mean is derived are returned in a data.frame. If FALSE, the mean hydrograph is returned}
}
\value{
a numeric vector which is the mean of the top n peak events in the flow series. Also a plot of the n hydrographs and the design hydrograph. If the RetAll argument equals TRUE, a data.frame of the n hydrographs is returned instead.
}
\description{
Extracts a mean hydrograph from a flow series
}
\details{
All the peaks over a user defined threshold are identified and separated by a user defined value 'qu', which is a quantile of flow. The top n peaks are selected and the hydrographs extracted. Each hydrograph is centred on the peak and truncated either side, where the flow falls below the 'qu' quantile flow. All events are scaled to have a peak flow of one, and the mean of these is taken as the scaled design hydrograph. After an initial view of the hydrograph, it can be truncated using the 'xst' and 'xend' arguments. The default is to select 10 hydrographs for averaging, however, there may well be fewer if the sample is short.
}
\examples{
#Extract a design hydrograph from the Thames daily mean flow. Then print the resulting hydrograph
ThamesDesHydro <- DesHydro(ThamesPQ$Q)
ThamesDesHydro
#Do the same but truncate the design hydrograph and the plot from the first point to the 30th
DesHydro(ThamesPQ$Q, xst = 1, xend = 30)
#adjust the qu value to see the impact
ThamesDesHydro <- DesHydro(ThamesPQ$Q, qu = 0.7)
#Return all the hydrographs
ThamesHydros <- DesHydro(ThamesPQ$Q, xst = 1, xend = 30, RetAll = TRUE)
#view the first six rows of the hydrographs
head(ThamesHydros)
}
\author{
Anthony Hammond
}
