% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{UAF}
\alias{UAF}
\title{Urban adjustment factor (UAF) and percentage runoff urban adjustment factor (PRUAF)}
\usage{
UAF(CDs = NULL, URBEXT2000, BFIHOST)
}
\arguments{
\item{CDs}{catchment descriptors derived from either GetCDs or CDsXML}

\item{URBEXT2000}{quantification of catchment urbanisation (used when CDs is not)}

\item{BFIHOST}{baseflow index as a function of hydrological soil type of the catchment (used when CDs is not)}
}
\value{
a data.frame with columns UAF and PRUAF
}
\description{
UAF and PRUAF from catchment descriptors for QMED estimation in ungauged urban catchments
}
\examples{
#Get some catchment descriptors for an urban catchment calculate the UAF & PRUAF
CDs.53006 <- GetCDs(53006)
UAF(CDs.53006)
#Calculate UAF and PRUAF using a user input URBEXT2000 and BFIHOST
UAF(URBEXT2000 = 0.1138, BFIHOST = 0.3620)
}
\author{
Anthony Hammond
}
