% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{Kappa3AM}
\alias{Kappa3AM}
\title{Kappa3 distribution - estimates directly from sample}
\usage{
Kappa3AM(x, RP = 100, q = NULL)
}
\arguments{
\item{x}{numeric vector (block maxima sample)}

\item{RP}{return period (default = 100)}

\item{q}{quantile (magnitude of variable)}
}
\value{
quantile as a function of RP or vice versa.
}
\description{
Estimated quantiles as a function of return period (RP) and vice versa, directly from the data
}
\details{
If the argument q is used, it overrides RP and provides RP as a function of q (magnitude of variable) as opposed to q as a function of RP. The parameters are estimated by the method of L-moments, as detailed in 'Hosking J. Wallis J. 1997 Regional Frequency Analysis: An Approach Based on L-moments. Cambridge University Press, New York'. The Kappa3 distribution is as defined by This is the Kappa3 distribution as defined in Kjeldsen, T (2019), 'The 3-parameter Kappa distribution as an alternative for use with FEH pooling groups.'Circulation - The Newsletter of the British Hydrological Society, no. 142.
}
\examples{
#Get an annual maximum sample and estimate the 50-year RP
AM.27090 <- GetAM(27090)
Kappa3AM(AM.27090$Flow, RP = 50)
#Estimate the RP for a 600m3/s discharge
Kappa3AM(AM.27090$Flow, q = 600)
}
\author{
Anthony Hammond
}
