% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{WGaugLSkew}
\alias{WGaugLSkew}
\title{Gauged pool weighted linear skewness (LSkew)}
\usage{
WGaugLSkew(x)
}
\arguments{
\item{x}{pooling group derived with the Pool() function}
}
\value{
the gauged weighted LSkew from a pooling group
}
\description{
Calculates the gauged weighted LSkew from a pooling group (enhanced single site)
}
\details{
Weighting method as according to Science Report: SC050050 - Improving the FEH statistical procedures for flood frequency estimation
}
\examples{
#Get some CDs, form a gauged pooling group, and estimate gauged LSkew
CDs.27051 <- GetCDs(27051)
Pool.27051 <- Pool(CDs.27051)
WGaugLSkew(Pool.27051)
}
\author{
Anthony Hammond
}
