% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umr_deconv.R
\name{umr_deconv}
\alias{umr_deconv}
\alias{quant_deconv}
\title{Carpentier and  Schluter 2016  deconvolution method  for unmatched
    monotone regression}
\usage{
umr_deconv(xx, yy, sig, error = "normal", bw = "dboot1", adjust = 1, n = 512)

quant_deconv(
  yy,
  sig,
  error = "normal",
  bw = "dboot1",
  adjust = 1,
  n = 512,
  monotonize = base::cummax
)
}
\arguments{
\item{xx}{X (covariate or predictor) observation vector}

\item{yy}{Y (response) observation vector (numeric)}

\item{sig}{standard deviation of epsilon (passed to DeconCdf)}

\item{error}{Must be "normal" or "laplacian" or "snormal"; see help("DeconCdf")}

\item{bw}{Bandwidth choice or method for kernel estimator; see help("DeconCdf")}

\item{adjust}{See help("DeconCdf")}

\item{n}{See help("DeconCdf")}

\item{monotonize}{is a function taking a numeric vector argument which
returns an increasing numeric vector of the same length.  This is used
to monotonize the output of the CDF from deconvolution, which is not
guaranteed to be a "bona-fide" CDF in the sense that it may not be
monotone.}
}
\description{
Carpentier and  Schluter 2016  deconvolution method  for unmatched
    monotone regression
}
\details{
quant_deconv implements Carpentier and Schluter 2016
    deconvolution method for unmatched monotone regression, using deconv
    package. Note that because the DeconCdf() function computes the CDF
    but there is no direct code for computing the quantile function, we
    use approxfun to create the quantile function; this may be slow.
    quant_deconv() returns a vector of length length(yy).  Then umr_deconv
    is a wrapper for quant_deconv.  NOTE: It returns the output of
    approxfun, which is may change over time.  The output value is of type
    function.  We linearly interpolate between the points i/n.
}
\examples{


library(distr)
mysig <- 1 ##  std dev
errdist <- distr::Norm(0, sd=mysig)
mm0 <- function(xx){xx}
 nn <- 300
 xx <- sort(runif(n=nn, 0, 7))
 yy <- mm0(xx) + errdist@r(nn)
 ## plot(xx,yy)
 modeldistname <- truedistname <- "Gauss" ## used for savefile name
myScale <- mysig

xx <- sort(runif(n=nn, 0, 7))
mmtrue <- mm0(xx)
yy <- mmtrue + errdist@r(nn)
plot(xx,yy)
qq <- quant_deconv(yy, sig=1, error="normal")
lines(xx, ## already sorted
     qq)
}
