% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIAGNOSTICS.R
\name{UPG.Diag}
\alias{UPG.Diag}
\title{MCMC Diagnostics for \code{UPG.Probit}, \code{UPG.Logit}, \code{UPG.MNL} and \code{UPG.Binomial} objects using \code{coda}}
\usage{
UPG.Diag(object = NULL)
}
\arguments{
\item{object}{an object of class \code{UPG.Probit}, \code{UPG.Logit}, \code{UPG.MNL} or \code{UPG.Binomial}.}
}
\value{
Returns a list containing effective sample size, effective sampling rate and inefficiency factors for each coefficient. Specifically, maximum, minimum and median as well as detailed results for each coefficient are returned.
}
\description{
\code{UPG.Diag} computes a number of MCMC diagnostics based on the Markov chains that are contained in the model output returned by \code{UPG}.
}
\examples{
\donttest{
# estimate a probit model using example data
library(UPG)
data(lfp)
y = lfp[,1]
X = lfp[,-1]
results.probit = UPG(y = y, X = X, type = "probit", verbose=TRUE)

# compute MCMC diagnostics
UPG.Diag(results.probit)
}

}
\author{
Gregor Zens
}
