% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LOGLIK.R
\name{logLik.UPG.MNL}
\alias{logLik.UPG.MNL}
\title{Compute log-likelihoods from UPG.MNL objects}
\usage{
\method{logLik}{UPG.MNL}(object = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{UPG.MNL}.}

\item{...}{other logLik parameters.}
}
\value{
Returns a numeric of class \code{logLik} with attributes containing the number of estimated parameters and the number of observations.
}
\description{
\code{logLik} can be used to compute log-likelihoods from \code{UPG.MNL} objects. The log-likelihood is based on the posterior mean of the coefficients.
}
\examples{
\donttest{
# estimate a multinomial logit model using example data
library(UPG)
data(program)
y = program[,1]
X = program[,-1]
results.mnl = UPG(y = y, X = X, model = "mnl")

# extract log-likelihood
ll.mnl = logLik(results.mnl)

}
}
\seealso{
\code{\link{summary.UPG.MNL}} to summarize a \code{UPG.MNL} object and create tables.
\code{\link{plot.UPG.MNL}} to plot a \code{UPG.MNL} object.
\code{\link{coef.UPG.MNL}} to extract coefficients from a \code{UPG.MNL} object.
}
\author{
Gregor Zens
}
