% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality.threshold.R
\name{quality.threshold}
\alias{quality.threshold}
\title{Function for the description of the qualities of one or two decision thresholds or threshold.}
\usage{
quality.threshold(ref, test, threshold, threshold.upper = NULL)
}
\arguments{
\item{ref}{The reference standard. A column in a data frame or a vector indicating the classification by the reference test. The reference standard must be coded either as 0 (absence of the condition) or 1 (presence of the condition)}

\item{test}{The index test or test under evaluation. A column in a dataset or vector indicating the test results in a continuous scale.}

\item{threshold}{The decision threshold of a dichotomization method, or the lower decision threshold of a trichotomization method.}

\item{threshold.upper}{(default = NULL). The upper decision threshold of a trichotomization method. When NULL, the test scores are dichotomized.}
}
\value{
{ A list of}
\describe{
  \item{table}{The confusion table of {diag x ref}, where diag is the diagnosis based on the test, when applying the threshold(s). The reference standard (ref) has categories 0 and 1, while the diagnosis based on the test scores (diag) has categories 0 and 1 in the case of applying a single threshold (dichotomization), and the categories 0, NA and 1 in the case of trichotomization. In the case of the Uncertain Interval trichotomization method, the row NA shows the count of test scores within the Uncertain Interval. When applying the trichotomization method TG-ROC, the row NA shows the count of the test scores within the Intermediate Range. Table cell {0, 0} shows the True Negatives (TN), cell {0, 1} shows the False Negatives (FN), cell {1, 0} shows the False Positives (FP), and cell {1, 1} shows the True Positives (TP).}
  \item{cut}{The values of the threshold(s).}
  \item{indices}{A named vector, with the following statistics for the test-scores with diagnosis 0 or 1:
    \itemize{
      \item{prevalence: }{Diagnosable patients with the targeted condition / Total diagnosable sample = (TP+FN)/(TN+FP+FN+TP)}
      \item{correct.classification.rate (or Accuracy): }{(TP+TN)/(TN+FP+FN+TP)}
      \item{balance.correct.incorrect : }{(TP+TN)/(FP+FN)}
      \item{specificity: }{TN/(TN+FN)}
      \item{sensitivity: }{TP/(TP+FN)}
      \item{negative.predictive.value: }{TN/(TN+FN)}
      \item{positive.predictive.value: }{TP/(TN+FN)}
      \item{neg.likelihood.ratio: }{(1-sensitivity)/specificity}
      \item{pos.likelihood.ratio: }{sensitivity/(1-specificity)}

  }
}
}
}
\description{
This function can be used for both dichotomization (single threshold or cut-point) methods and for trichotomization (two thresholds or cut-points) methods. In the case of the Uncertain Interval trichotomization method, it provides descriptive statistics for the test scores outside the Uncertain Interval. For the TG-ROC trichotomization method it provides the descriptive statistics for TG-ROC's Valid Range.
}
\examples{
# A simple test
ref=c(rep(0,500), rep(1,500))
test=c(rnorm(500,0,1), rnorm(500,1,1))
ua = uncertain.interval(ref, test)
quality.threshold(ref, test, threshold=ua[1], threshold.upper=ua[2])
}

