% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as.rgb}
\alias{as.rgb}
\title{Convert Color-Name or RGB-Code to Possibly Semi-Transparent RGB-code.}
\usage{
as.rgb(col = "black", alpha = 1)
}
\arguments{
\item{col}{(character) name of the color to be converted/transformed into RGB-space (code). Only
those colors can be used which are part of the set returned by function colors(). Defaults
to "black".}

\item{alpha}{(numeric) value specifying the transparency to be used, 0 = completely transparent, 
1 = opaque.}
}
\value{
RGB-code
}
\description{
Function takes the name of a color and converts it into the rgb space. Parameter "alpha" allows
to specify the transparency within [0,1], 0 meaning completey transparent and 1 meaning completey
opaque. If an RGB-code is provided and alpha != 1, the RGB-code of the transparency adapted color 
will be returned.
}
\examples{
# convert character string representing a color to RGB-code
# using alpha-channel of .25 (75\\% transparent)
as.rgb("red", alpha=.25)

# same thing now using the RGB-code of red (alpha=1, i.e. as.rgb("red"))
as.rgb("#FF0000FF", alpha=.25)
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
