% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{t.coef}
\alias{t.coef}
\title{Transformation of Coefficients.}
\usage{
\method{t}{coef}(
  coeffs0,
  K = NULL,
  Maxi = NULL,
  model = NULL,
  signJ = NULL,
  eps = sqrt(.Machine$double.eps),
  ...
)
}
\arguments{
\item{coeffs0}{(numeric) vector of function coefficients to be transformed into the
re-parameterized form}

\item{K}{(numeric) constant value 'K'}

\item{Maxi}{(numeric) max. value}

\item{model}{(integer) specifying which model shall be back-transformed}

\item{signJ}{(integer) either 1 or -1}

\item{eps}{(numeric) constant used instead of zero in case of log-transformation}

\item{...}{additional parameters}
}
\value{
(numeric) vector of coefficients in re-parameterized form
}
\description{
This function performs transformation from the original parameterization into the 'VFP'-package
internal re-parameterized form.
}
\details{
In the 'VFP' package models are re-parameterized to have better control over the constrained
solution-space, i.e. only models may be fitted generating non-negative fitted values. This 
function is intended to be for internal use only.
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
			Florian Dufey \email{florian.dufey@roche.com}
}
