% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multinomLRcode.R
\name{HTMLsummary}
\alias{HTMLsummary}
\title{Summarize the risk prediction plots.}
\usage{
HTMLsummary(fit, summaryfile, filename, title)
}
\arguments{
\item{fit}{A \code{multinom} object or a character vector.  In the latter case the vector consists of the names of the outcome levels.}

\item{summaryfile}{Name of the resulting HTML file}

\item{filename}{The filename that was given to the \code{colplot}, \code{cchart} or \code{ccchart} commands.}

\item{title}{Title of the summary.}
}
\description{
Create an HTML page that summarizes all the plots that have been created to visualize the risk prediction.  When a patient was given, a patient summary will be given as well.  This function is only applicable for \code{multinom} objects.
}
\examples{
# only applicable for multinom objects
library(nnet)
library(R2HTML)
library(VGAMdata)
data(xs.nz)
marital.nz <- xs.nz[,c("marital","sex","age","height","weight")]
mydata <- marital.nz[complete.cases(marital.nz),]
fit <- multinom(marital ~ sex + age + height + weight, data = mydata,model=TRUE)
# for multinimial logistic regression, a vector of risk labels needs to be made 
# and provided to the colplot function
outnames=colnames(fitted(fit))
labels=c(paste("Linear predictor for",outnames[-1]),paste
				("Predicted chance of being",outnames))
patient1=data.frame(sex="F",age=27,height=1.68,weight=58.6)
colplot(fit,coloroptions=3,risklabel=labels,filename="multinom")
# this generates a file mysummary.html containing all plots provided by the above 
# colplot statement. 
HTMLsummary(fit=fit, summaryfile="mysummary", filename="multinom",
		title="Global summary of a multinomial logistic regression model estimating 
				the risk on different marital statuses.")
# this generates a file mysummary1.html containing all plots provided by the below 
# colplot statement.  Since an observation is provided, a patient summary will also 
# be given.
colplot(fit,obs=patient1,coloroptions=3,risklabel=labels,filename="multinom")
HTMLsummary(fit=fit, summaryfile="mysummary1", filename="multinom",
		title="Global summary of a multinomial logistic regression model estimating 
				the risk on	different marital statuses.")
}
\author{
Vanya Van Belle
}
\references{
Van Belle V., Van Huffel S., Timmerman D., Froyman W., Bourne T. and Van Calster B., \emph{A color based nomogram for Multinomial Logistic Regression}, Internal Report 16-28, ESAT-Stadius, KU Leuven (Leuven, Belgium), 2016
}

