% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting.R
\name{relabel_na}
\alias{relabel_na}
\title{Relabel samples containing 'NA' as outside any interest area}
\usage{
relabel_na(data = data, NoIA = NoIA)
}
\arguments{
\item{data}{A data table object output by \code{\link{prep_data}}.}

\item{NoIA}{A positive integer indicating the number of interest areas defined 
when creating the study.}
}
\value{
A data table with the same dimensions as \code{data}.
}
\description{
\code{relabel_na} examines interest area columns (LEFT_INTEREST_AREA_ID, 
RIGHT_INTEREST_AREA_ID, LEFT_INTEREST_AREA_LABEL, and RIGHT_INTEREST_AREA_LABEL)
for cells containing NAs. If NA, the missing values in the ID columns are 
relabeled as 0 and missing values in the LABEL columns are relabeled as 'Outside'.
}
\examples{
\dontrun{
library(VWPre)
# To relabel the NAs...
df <- relabel_na(data = dat, NoIA = 4)
}
}

