% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertwise.R
\name{vertex_analysis}
\alias{vertex_analysis}
\title{Vertex-wise analysis}
\usage{
vertex_analysis(
  model,
  contrast,
  random,
  surf_data,
  p = 0.05,
  atlas = 1,
  smooth_FWHM,
  VWR_check = TRUE
)
}
\arguments{
\item{model}{An N X V data.frame object containing N rows for each subject and V columns for each predictor included in the model. This data.frame should not include the random effects variable.}

\item{contrast}{A numeric vector or object containing the values of the predictor of interest. The cluster-thresholded t-stat maps will be estimated only for this predictor}

\item{random}{An object containing the values of the random variable (optional)}

\item{surf_data}{A matrix object containing the surface data, see SURFvextract() or HIPvextract() output format.}

\item{p}{A numeric object specifying the p-value to threshold the results (Default is 0.05)}

\item{atlas}{A numeric integer object corresponding to the atlas of interest. 1=Desikan, 2=Schaefer-100, 3=Schaefer-200, 4=Glasser-360, 5=Destrieux-148.}

\item{smooth_FWHM}{A numeric vector object specifying the desired smoothing width in mm}

\item{VWR_check}{A boolean object specifying whether to check and validate system requirements. Default is TRUE.}
}
\value{
A list object containing the cluster level results, thresholded t-stat map, and positive, negative and bidirectional cluster maps.
}
\description{
Fits a linear or linear mixed model with the cortical or hippocampal surface data as the predicted outcome, and returns cluster-thresholded (Random field theory) t-stat map selected contrast.
}
\details{
The function imports and adapts the \href{https://brainstat.readthedocs.io/en/master/_modules/brainstat/stats/SLM.html#SLM)}{ 'BraiStat' Python library}.

Output definitions:
\itemize{
\item \code{nverts}: number of vertices in the cluster
\item \code{P}: p-value of the cluster
\item \verb{X, Y and Z}: MNI coordinates of the vertex with the highest t-statistic in the cluster.
\item \code{tstat}: t statistic of the vertex with the highest t-statistic in the cluster
\item \code{region}: the region this highest -statistic vertex is located in, as determined/labelled by the selected atlas
}
}
\examples{
demodata = readRDS(system.file('demo_data/SPRENG_behdata_site1.rds', 
package = 'VertexWiseR'))[1:100,]
CTv = readRDS(file = url(paste0("https://github.com",
"/CogBrainHealthLab/VertexWiseR/blob/main/inst/demo_data/",
"SPRENG_CTv_site1.rds?raw=TRUE")))[1:100,]

vertexwise_model=vertex_analysis(model=demodata[,c(2,7)], 
contrast=demodata[,7], surf_data = CTv, atlas=1,p = 0.05, 
VWR_check=FALSE)

#Description of the output:
#vertexwise_model$cluster_level_results
}
