% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otherfunc.R
\name{smooth_surf}
\alias{smooth_surf}
\title{Smooth surface}
\usage{
smooth_surf(surf_data, FWHM, VWR_check = TRUE)
}
\arguments{
\item{surf_data}{A N x V matrix object containing the surface data (N row for each subject, V for each vertex), in fsaverage5 (20484 vertices), fsaverage6 (81924 vertices), fslr32k (64984 vertices) or hippocampal (14524 vertices) space. See also Hipvextract(), SURFvextract() or FSLRvextract output formats. Alternatively, a string object containing the path to the surface object (.rds file) outputted by extraction functions may be given.}

\item{FWHM}{A numeric vector object containing the desired smoothing width in mm}

\item{VWR_check}{A boolean object specifying whether to check and validate system requirements. Default is TRUE.}
}
\value{
A matrix object with smoothed vertex-wise values
}
\description{
Smooths surface data at defined full width at half maximum (FWHM) as per the corresponding template of surface data
}
\examples{
surf_data = readRDS(file = url(paste0("https://github.com",
"/CogBrainHealthLab/VertexWiseR/blob/main/inst/demo_data/",
"FINK_Tv_ses13.rds?raw=TRUE")))[1:3,]

surf_data_smoothed=smooth_surf(surf_data, 10, VWR_check=FALSE);
}
