% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jacobi.R
\name{16. Jacobi Symbol}
\alias{16. Jacobi Symbol}
\alias{Jacobi}
\alias{Jacobi.default}
\alias{Jacobi.numeric}
\alias{Jacobi.vli}
\title{Computation of the Jacobi Symbol for vli Objects}
\usage{
Jacobi(a, n)

\method{Jacobi}{default}(a, n)

\method{Jacobi}{numeric}(a, n)

\method{Jacobi}{vli}(a, n)
}
\arguments{
\item{a}{object of class vli or 32 bits integer}

\item{n}{positive odd integer; object of class vli or 32 bits integer}
}
\value{
object of class vli with value \code{-1}, \code{0} or \code{1}.
}
\description{
Computation of the Jacobi Symbol for vli (Very Large Integers) objects. The Jacobi Symbol is a generalization of the Legendre Symbol, not being necessary that \code{n} be a prime number.

It is needed in many algorithms of modular arithmetic, computational number theory and cryptography. For example, it is used by the present package in the Solovay-Strassen probabilistic primality test.
}
\examples{
x <- as.vli("342635653456")
y <- as.vli("3210591001")
Jacobi(x, y)
}
\author{
Javier Leiva Cuadrado
}
