% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divisor.R
\name{14. Finding a random divisor}
\alias{14. Finding a random divisor}
\alias{divisor}
\alias{divisor.default}
\alias{divisor.numeric}
\alias{divisor.vli}
\title{Finding a Random Divisor of a vli Object}
\usage{
divisor(n, iter = 100)

\method{divisor}{default}(n, iter = 100)

\method{divisor}{numeric}(n, iter = 100)

\method{divisor}{vli}(n, iter = 100)
}
\arguments{
\item{n}{object of class vli or 32 bits integer}

\item{iter}{number of iterations for testing if the given number is prime; numeric}
}
\value{
object of class vli
}
\description{
\code{divisor} returns a randomly chosen divisor of a given number.
}
\details{
The algorithm determines if the given number is prime or composite by usign the Miller-Rabin Probabilistic Primality Test. If it is prime, it returns the number itself. If it is composite, it returns a randomly chosen divisor. The number of iterations is configurable to set the desired accuracy. A too low number of iterations could cause an infinite loop because of being looking for a divisor of a prime number.
}
\examples{
r <- rvliprime(100)
r
x <- r * 51
x
divisor(x, iter = 100)
}
\author{
Javier Leiva Cuadrado
}
