% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjusted_coef.R
\name{adjusted_coef}
\alias{adjusted_coef}
\title{Adjust coefficient for confounders}
\usage{
adjusted_coef(effect_xz, effect_uxz, effect_d)
}
\arguments{
\item{effect_xz}{Effect of x on y given z}

\item{effect_uxz}{Effect of u on y given x and z}

\item{effect_d}{Effect size difference of interest}
}
\value{
Adjusted effect size of x on y given u and z
}
\description{
This function calculates the adjusted effect after
controlling for confounding effects. You can use d values or
standardized regression coefficients.
}
\examples{

adjusted_coef(effect_xz = .2,
  effect_uxz = .4,
  effect_d = .12)

}
\keyword{cohen's}
\keyword{correlation}
\keyword{d}
\keyword{dependent}
\keyword{effect}
\keyword{measures}
\keyword{paired-sample}
\keyword{repeated}
\keyword{size}
\keyword{t-test}
