% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{data_citation}
\alias{data_citation}
\alias{data_dictionary}
\alias{get_metadata}
\title{Layer Metadata}
\usage{
data_citation(x = NULL, metadataID = NULL)

data_dictionary(x = NULL, metadataID = NULL)

get_metadata(x = NULL, metadataID = NULL)
}
\arguments{
\item{x}{Object of class \code{vicmap_promise} (likely passed from \code{\link[=vicmap_query]{vicmap_query()}})}

\item{metadataID}{character: ID of data (useful if data is not available through WFS)}
}
\value{
citation, data.frame or list
}
\description{
formatted metadata attributes of a given vicmap layer (\code{vicmap_query(layer)}).
Metadata is retrieved from the Vicmap catalogue. \code{data_citation()} prints a BibTex style citation for a given record;
similar to \code{base::citation()}. \code{data_dictionary()} returns a table with names, types and descriptions of the data within the
selected layer (see details). \code{get_metdata()} returns a list with three elements, containing metadata, the data dictionary and the url of the
metadata for the record.
}
\examples{
\donttest{
try(
data_citation(vicmap_query(layer = "datavic:VMHYDRO_WATERCOURSE_DRAIN"))
)
}
\donttest{
try(
data_dictionary(vicmap_query(layer = "datavic:VMHYDRO_WATERCOURSE_DRAIN"))
)
}
\donttest{
try(
get_metadata(vicmap_query(layer = "datavic:VMHYDRO_WATERCOURSE_DRAIN"))
)
}
}
