\name{D2RVine}                
\alias{D2RVine}

\title{Transform D-vine to R-vine structure}

\description{
This function transforms a D-vine structure from the package CDVine to the corresponding R-vine structure.
}

\usage{
D2RVine(order, family, par, par2=rep(0,length(family)))
}

\arguments{
  \item{order}{A d-dimensional vector specifying the order of the nodes in the D-vine.} 
  \item{family}{A d*(d-1)/2 vector of pair-copula families with values\cr
		\code{0} = independence copula \cr
	        \code{1} = Gaussian copula \cr
	        \code{2} = Student t copula (t-copula) \cr
	        \code{3} = Clayton copula \cr
	        \code{4} = Gumbel copula \cr
	        \code{5} = Frank copula \cr
	        \code{6} = Joe copula \cr 
		\code{7} = BB1 copula \cr
		\code{8} = BB6 copula \cr
		\code{9} = BB7 copula \cr
		\code{10} = BB8 copula \cr
		\code{13} = rotated Clayton copula (180 degrees; ``survival Clayton'') \cr
		\code{14} = rotated Gumbel copula (180 degrees; ``survival Gumbel'') \cr
		\code{16} = rotated Joe copula (180 degrees; ``survival Joe'') \cr 
		\code{17} = rotated BB1 copula (180 degrees; ``survival BB1'')\cr
		\code{18} = rotated BB6 copula (180 degrees; ``survival BB6'')\cr
		\code{19} = rotated BB7 copula (180 degrees; ``survival BB7'')\cr
		\code{20} = rotated BB8 copula (180 degrees; ``survival BB8'')\cr
		\code{23} = rotated Clayton copula (90 degrees) \cr
		\code{24} = rotated Gumbel copula (90 degrees) \cr
		\code{26} = rotated Joe copula (90 degrees) \cr
		\code{27} = rotated BB1 copula (90 degrees) \cr
		\code{28} = rotated BB6 copula (90 degrees) \cr
		\code{29} = rotated BB7 copula (90 degrees) \cr
		\code{30} = rotated BB8 copula (90 degrees) \cr
		\code{33} = rotated Clayton copula (270 degrees) \cr
		\code{34} = rotated Gumbel copula (270 degrees) \cr
		\code{36} = rotated Joe copula (270 degrees) \cr
		\code{37} = rotated BB1 copula (270 degrees) \cr
		\code{38} = rotated BB6 copula (270 degrees) \cr
		\code{39} = rotated BB7 copula (270 degrees) \cr
		\code{40} = rotated BB8 copula (270 degrees) 
		}
  \item{par}{A d*(d-1)/2 vector of pair-copula parameters.}
  \item{par2}{A d*(d-1)/2 vector of second pair-copula parameters (optional; default: \code{par2 = rep(0,length(family))}), 
  necessary for the t-, BB1, BB6, BB7 and BB8 copulas.}
}

\value{
An \code{\link{RVineMatrix}} object.
}

\author{Ulf Schepsmeier}

\seealso{\code{\link{RVineMatrix}}, \code{\link{C2RVine}}, \code{\link{R2DVine}}}

\examples{
# simulate a sample of size 500 from a 4-dimensional D-vine 
# copula model with mixed pair-copulas
# load package CDVine
library(CDVine)
d = 4
dd = d*(d-1)/2
order = 1:d
family = c(1,2,3,4,7,3)
par = c(0.5,0.4,2,1.5,1.2,1.5)
par2 = c(0,5,0,0,2,0)
type = 2
simdata = CDVineSim(500,family,par,par2,type)

# determine log-likelihood
out = CDVineLogLik(simdata,family,par,par2,type)
out$loglik

# transform to R-vine matrix notation
RVM = D2RVine(order,family,par,par2)

# check that log-likelihood stays the same
out2 = RVineLogLik(simdata,RVM)
out2$loglik
}

