\name{BB7Copula}
\alias{BB7Copula}
\alias{surBB7Copula}
\alias{r90BB7Copula}
\alias{r270BB7Copula}

\title{
Constructor of the BB7 family and its derivatives
}
\description{
Constructs an object of the \code{\linkS4class{BB7Copula}} (survival \code{sur}, 90 degree rotated \code{r90} and 270 degree rotated \code{r270}) family for a given parameter.
}
\usage{
BB7Copula(param)
surBB7Copula(param)
r90BB7Copula(param)
r270BB7Copula(param)
}

\arguments{
  \item{param}{
The parameter \code{param} defines the copula through \code{theta} and \code{delta}.
}
}
\value{
One of the respective BB7 copula classes (\code{\linkS4class{BB7Copula}}, \code{\linkS4class{surBB7Copula}}, \code{\linkS4class{r90BB7Copula}}, \code{\linkS4class{r270BB7Copula}}).
}
\references{
Joe, H., (1997). Multivariate Models and Dependence Concepts. Monogra. Stat. Appl. Probab. 73, London: Chapman and Hall.
}
\author{
Benedikt Graeler
}
\seealso{
See also \code{\link{BB6Copula}}, \code{\link{BB7Copula}}, \code{\link{BB8Copula}} and \code{\link{joeCopula}} for further wrapper functions to the \code{\link{VineCopula-package}}. 
}
\examples{
library(copula)

persp(BB7Copula(c(1,1.5)),dCopula, zlim=c(0,10))
persp(surBB7Copula(c(1,1.5)),dCopula, zlim=c(0,10))
persp(r90BB7Copula(c(-1,-1.5)),dCopula, zlim=c(0,10))
persp(r270BB7Copula(c(-1,-1.5)),dCopula, zlim=c(0,10))
}