% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psmsl_stations.R
\name{psmsl.stations}
\alias{psmsl.stations}
\title{Generates a list of active and historic PSMSL stations}
\usage{
psmsl.stations(type = "RLR", country = "all", sort.by = "country")
}
\arguments{
\item{type}{data quality class; can be 'metric' or 'RLR' - see \url{http://www.psmsl.org} 
for documentation}

\item{country}{if desired, the full list of stations can be filtered by up to three 
alphabetical characters. Specific country codes can be entered ("USA"), or 
abbreviated codes in case the user isn't sure of the country code ("U"; "US"). 
Upper case and lower case codes are both acceptable. Default is 'all' stations.}

\item{sort.by}{the criterion for sorting the final dataframe.  By default, 
output is sorted alphabetically by country code. Any column name can be used 
for sorting: 'name', 'id', 'lat', 'long', 'country', 'date', 
'coastline', or \code{stn}}
}
\value{
A \code{data.frame} containing all Permanent Service for Mean Sea Level 
stations meeting country code criterion. Data frame is sorted by the column specified 
in argument \code{sort.by}
}
\description{
Generates a list of active and historic tide stations 
hosted by the Permanent Service for Mean Sea Level (\url{http://www.psmsl.org})
}
\details{
A \code{data.frame} containing all Permanent Service for Mean Sea Level 
stations meeting country code criterion. Data frame is sorted by the column 
specified in argument \code{sort.by}
}
\examples{
\dontrun{
# examples require internet connection
stn.df <- psmsl.stations()
stn.df2 <- psmsl.stations(country = "USA", sort.by = "date")
stn.df3 <- psmsl.stations(type = "metric")
}
}
\seealso{
\code{\link{psmsl}}
}
