% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miniTools.R
\name{convert_parameters}
\alias{convert_parameters}
\title{Convert Parameters}
\usage{
convert_parameters(args, converters)
}
\arguments{
\item{args}{a named list, which values will be converted.}

\item{converters}{a vector of function. Each function will be applied to
each values with the exception of values already converted by a
previous converter.}
}
\value{
a named \code{list} object with values converted by converters.
}
\description{
convert_parameters
Applies a list of converters to each values on a list.
If a value is modified during the conversion (successfull conversion)
then, no further convert will be applied to this value, so values are
only converted once.
}
\examples{
boolean_converter <- function(x) {
  return(if (x == "TRUE") TRUE else if (x == "FALSE") FALSE else x)
}
parameters <- W4MRUtils::convert_parameters(
  list("x" = "TRUE"),
  c(boolean_converter)
)
print(parameters$`some-parameter`)
## "TRUE" has becomes TRUE.

}
\author{
L.Pavot
}
