% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miniTools.R
\name{parse_args}
\alias{parse_args}
\title{Parse Command arguments}
\usage{
parse_args(args = NULL, convert_booleans = TRUE, convert_numerics = TRUE)
}
\arguments{
\item{args}{optional, provide arguments to parse.
This function will use 'commandArgs()' if args is not provided}

\item{convert_booleans}{logical - tells the function to convert
values into logical if their value is "TRUE" or "FALSE".}

\item{convert_numerics}{logical - tells the function to convert
values into numeric if possible.}
}
\value{
a named \code{list} object containing the input parameters in values
and the parameters names in names
}
\description{
parse_args
Replacement for the parseCommandArgs utility from batch.
Note that inputs like \verb{script.R some-list c(1, 2, 3)} will result in
args$\code{some-list} to be the string "c(1, 2, 3)", and not a vector anymore
as this ability was permitted by dangerous behaviours from the
batch package (the usage of \code{eval} which MUST NEVER be used on user's
inputs).

To get a list of numeric from users, instead of using the \code{c(1, 2)} trick,
please, use regular lists parsing:

\if{html}{\out{<div class="sourceCode">}}\preformatted{> args$`some-list`
[1] "1,2"
args$`some-list` <- as.numeric(strsplit(args$`some-list`, ",")[[1]])
> args$`some-list`
[1] 1 2
}\if{html}{\out{</div>}}
}
\examples{
parameters <- W4MRUtils::parse_args()
print(parameters$`some-parameter`)

}
\author{
L.Pavot
}
