% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{semiorthogonalize}
\alias{semiorthogonalize}
\title{Internal function: Semiorthogonal-type transformation of X2 to Z2}
\usage{
semiorthogonalize(Z2s, X2, Delta2, SVD = TRUE, postmult = FALSE)
}
\arguments{
\item{Z2s}{Matrix from which we take negative square root for
\eqn{X2 * Delta2 * Z2s^(1/2)}.}

\item{X2}{Design matrix of auxiliary regressors to be transformed to Z2}

\item{Delta2}{Scaling matrix such that diagonal of
\eqn{\bar{\Delta}_2 \bar{X}_2^{\top} \bar{M}_1 \Delta_{2}} is one (ignored
scaling by \eqn{n} because not needed in code).
See \insertCite{deluca2018glm;textual}{WALS}}

\item{SVD}{If \code{TRUE}, uses \code{\link[base]{svd}} to compute eigendecomposition
of Z2s, otherwise uses \code{\link[base]{eigen}}.}

\item{postmult}{If \code{TRUE}, then it uses
\eqn{Z2s^{-1/2} = H \Lambda^{-1/2} H^{\top}}, where \eqn{H} contains
the eigenvectors of Z2s in its columns and \eqn{\Lambda} the corresponding
eigenvalues. If \code{FALSE} it uses \eqn{Z2s^{-1/2} = H \Lambda^{-1/2}}.}
}
\description{
Uses the matrix Z2s (called \eqn{\bar{\Xi}} in eq. (9) of
\insertCite{deluca2018glm;textual}{WALS}) to transform \eqn{\bar{X}_2} to
\eqn{\bar{Z}_2}, i.e. to perform \eqn{\bar{Z}_2 = \bar{X}_2 \bar{\Delta}_2 \bar{\Xi}^{-1/2}}.
For WALS in the linear regression model, the variables do not have a "bar".
}
\section{On the "semiorthogonal-type" transformation}{

For WALS GLM (and WALS in the linear regression model),
the transformation is semiorthogonal (ignored scaling by \eqn{n} for clarity
and because it is not needed in the code)
in the sense that \eqn{\bar{M}_{1} \bar{Z}_{2}} is semiorthogonal since
\deqn{\bar{Z}_{2}^{\top} \bar{M}_1 \bar{Z}_{2} =
(\bar{Z}_{2}^{\top} \bar{M}_1) (\bar{M}_{1} \bar{Z}_{2}) = I_{k_2},}
where \eqn{\bar{M}_1} is an idempotent matrix.

For WALS in the NB2 regression model, \eqn{\bar{M}_{1} \bar{Z}_{2}} is not
semiorthogonal anymore due to the rank-1 perturbation in \eqn{\bar{M}_1} which
causes \eqn{\bar{M}_1} to not be idempotent anymore, see
the section "Transformed model" in \insertCite{huynhwalsnb;textual}{WALS}.

The transformation is the same as for WALS in the linear
regression model, note however, that the definition of \eqn{\Xi} in eq. (12)
of \insertCite{magnus2016wals;textual}{WALS} differs from eq. (9) of
\insertCite{deluca2018glm;textual}{WALS}: In
\insertCite{magnus2016wals;textual}{WALS}

\deqn{\Xi = diag(\lambda_1, \lambda_2, ...)}

defines the diagonal matrix of the eigenvalues of
\eqn{\Delta_2 X_{2}^{\top} M_{1} X_{2} \Delta_2}. The transformation then uses

\deqn{Z_{2} = X_2 \Delta_2 T \Xi^{-1/2},}

where $T$ contains the eigenvectors of
\eqn{\Delta_2 X_{2}^{\top} M_{1} X_{2} \Delta_2} in the columns.

In contrast,
\insertCite{deluca2018glm;textual}{WALS} defines

\deqn{\Xi = \Delta_2 X_{2}^{\top} M_{1} X_{2} \Delta_2}

(ignored scaling by \eqn{n} and notation with bar for easier comparison),
then the transformation is

\deqn{Z_2 = X_2 \Delta_2 \Xi^{-1/2}.}
}

\section{On the use of \code{postmult = TRUE}}{

The transformation triggered by \code{postmult = TRUE}
\eqn{Z2s^{-1/2} = H \Lambda^{-1/2} H^{\top}} is used in
\insertCite{huynhwalsnb;textual}{WALS}, whereas \code{postmult = FALSE}
uses \eqn{Z2s^{-1/2} = H \Lambda^{-1/2}} which is used in the original MATLAB
code for WALS in the linear regression model
\insertCite{magnus2010growth,deluca2011stata,kumar2013normallocation,magnus2016wals}{WALS},
see eq. (12) of \insertCite{magnus2016wals;textual}{WALS} for more details.
}

\references{
\insertAllCited{}
}
