% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScatterHistC.R
\name{ScatterHistN}
\alias{ScatterHistN}
\title{Plot a height scatter plot with marginals.  xvar is the independent variable (input or model), and yvar is the dependent variable, and zvar is the condition height.}
\usage{
ScatterHistN(frame, xvar, yvar, zvar, title, ..., annot_size = 3,
  colorPalette = "RdYlBu", nclus = 3, adjust_x = 1, adjust_y = 1)
}
\arguments{
\item{frame}{data frame to get values from}

\item{xvar}{name of the independent (input or model) column in frame}

\item{yvar}{name of the dependent (output or result to be modeled) column in frame}

\item{zvar}{name of height variable}

\item{title}{title to place on plot}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{annot_size}{numeric scale annotation text (if present)}

\item{colorPalette}{name of a Brewer palette (see http://colorbrewer2.org/ )}

\item{nclus}{scalar number of z-clusters to plot}

\item{adjust_x}{numeric adjust x density plot}

\item{adjust_y}{numeric adjust y density plot}
}
\description{
Plot a height scatter plot with marginals.  xvar is the independent variable (input or model), and yvar is the dependent variable, and zvar is the condition height.
}
\examples{

set.seed(34903490)
frm = data.frame(x=rnorm(50),y=rnorm(50))
frm$z <- frm$x+frm$y
WVPlots::ScatterHistN(frm, "x", "y", "z", title="Example Joint Distribution")

}
